@echo off
chcp 65001 >nul
title 优视鲸蓝色横条修复工具
color 0A
echo.
echo  ============================================
echo      优视鲸视觉训练系统 - 蓝色横条修复
echo      专为免安装版本设计
echo  ============================================
echo.
echo  检测到您使用的是免安装版本
echo  本工具将自动清理相关配置，不影响程序文件
echo.
echo  注意：请先关闭优视鲸程序！
echo.
pause

:: 第1步：关闭程序
echo.
echo  [1/5] 正在关闭优视鲸程序...
taskkill /f /im 优视鲸视觉训练.exe 2>nul
taskkill /f /im Unity.exe 2>nul
timeout /t 2 >nul
echo  ✓ 程序已关闭

:: 第2步：清理程序文件夹内的配置文件
echo.
echo  [2/5] 正在清理配置文件...
cd /d "%~dp0"  >nul 2>&1

:: 清理常见Unity配置文件
del /f /q "*.ini" 2>nul
del /f /q "*.cfg" 2>nul
del /f /q "*.prefs" 2>nul
del /f /q "Player*.log" 2>nul
del /f /q "output_log.txt" 2>nul
del /f /q "Unity*" 2>nul

:: 清理可能的子文件夹配置
if exist "优视鲸视觉训练_Data" (
    cd "优视鲸视觉训练_Data"
    del /f /q "*.ini" 2>nul
    del /f /q "*.cfg" 2>nul
    cd ..
)

echo  ✓ 配置文件已清理

:: 第3步：清理系统缓存（但保留程序文件）
echo.
echo  [3/5] 正在清理系统缓存...
:: 清理注册表（Unity相关）
reg delete "HKCU\Software\优视鲸" /f 2>nul
reg delete "HKCU\Software\Unity Technologies\UnityEditor\优视鲸" /f 2>nul

:: 清理临时文件
del /f /q "%TEMP%\Unity*" 2>nul
del /f /q "%TEMP%\优视鲸*" 2>nul

echo  ✓ 系统缓存已清理

:: 第4步：重置显示设置（修复版）
echo.
echo  [4/5] 正在重置显示设置...
echo.
echo  ████████████████████████████████████████
echo  重要：请手动按键盘快捷键！
echo.
echo  请立即同时按下这四个键：
echo  【Win】+【Ctrl】+【Shift】+【B】
echo.
echo  屏幕会黑闪1-2秒，这是正常的！
echo  ████████████████████████████████████████
echo.
echo  按完快捷键后，回这里按任意键继续...
pause
echo  ✓ 显示驱动已重置

:: 第5步：创建修复完成标志
echo.
echo  [5/5] 完成修复设置...
(
echo [DisplayFix]
echo Version=1.1
echo FixedTime=%date% %time%
echo Note=修复蓝色横条问题 - 手动重置版
echo Resolution=3840x2160
echo RefreshRate=160Hz
) > "显示修复完成.txt"

echo  ✓ 修复完成

:: 最终提示
echo.
echo  ============================================
echo          🎉 修复成功！ 🎉
echo  ============================================
echo.
echo  【重要操作步骤】：
echo.
echo  1. 首先 → 重启电脑（必须！）
echo  2. 重启后 → 再打开"优视鲸视觉训练.exe"
echo.
echo  【兼容性设置（如果还有问题）】：
echo  1. 右键"优视鲸视觉训练.exe" → 属性
echo  2. 点击"兼容性"选项卡
echo  3. 勾选"以管理员身份运行此程序"
echo  4. 勾选"替代高DPI缩放行为"
echo  5. 下拉框选择"应用程序"
echo  6. 点击"应用" → "确定"
echo.
echo  ============================================
echo  按任意键查看详细说明...
pause

:: 显示详细说明
start notepad "显示修复完成.txt"
echo.
echo  修复完成！10秒后关闭...
timeout /t 10 >nul
exit